"use client"

import { Loader, Check, X, } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useRouter } from "@/lib/navigation.router";
import { useStatusLoadingContent, UseStatusLoadingContentProps } from "../hook/use-status-loading-content";

const INTERNAL__loadingContent = {
  loading: <INTERNAL__Loading />,
  success: {
    content: <INTERNAL__Success />,
    timeout: 10000,
  },
  error: <INTERNAL__Error />,
} satisfies UseStatusLoadingContentProps

export function StatusRevalidateBannerApplicationSidebar() {
  const {
    isLoading,
    data: showing
  } = useStatusLoadingContent(INTERNAL__loadingContent)

  const router = useRouter()

  if (isLoading || !showing) {
    return
  }

  return (
    <Button
      variant={"ghost"}
      size="sm"
      className="w-full h-fit justify-start animate-in fade-in"
      onClick={() => {
        router.push('/agency/feeds')
      }}
    >
      <div className="py-4 flex items-center gap-2 justify-start">
        {showing}
      </div>
    </Button>
  )
}

function INTERNAL__Loading() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border animate-pulse"
        aria-hidden="true"
      >
        <Loader className="opacity-60 animate-spin size-3 stroke-2" />
      </div>
      <div className="flex grow items-center gap-12 animate-pulse">
        <div className="space-y-1">
          <p className="text-sm font-medium">Build in progress</p>
        </div>
      </div>
    </>
  )
}

function INTERNAL__Success() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border"
        aria-hidden="true"
      >
        <Check className="opacity-60 size-3 stroke-2 text-green-500 dark:text-green-600" />
      </div>
      <div className="flex grow items-center gap-12">
        <div className="space-y-1">
          <p className="text-sm font-medium">Built successfully!</p>
        </div>
      </div>
    </>
  )
}

function INTERNAL__Error() {
  return (
    <>
      <div
        className="flex size-6 shrink-0 items-center justify-center rounded-full border border-border"
        aria-hidden="true"
      >
        <X className="opacity-60 size-3 stroke-2 text-destructive" />
      </div>
      <div className="flex grow items-center gap-12 text-pretty">
        <p className="text-sm font-medium">Error during build.</p>
      </div>
    </>
  )
}
